from pyomo.environ import *
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import os
import pandas as pd
from openpyxl import load_workbook

os.chdir("C:/Users/agusv/Desktop/Estudio/Tesis/Csv")

methodology=[]
total_truck_costs=[]
total_cooler_costs=[]
costs = []
truck_emissions = []
cooler_emissions = []
emissions = []
epsilons = []
truckquantities = []
coolerquantities = []
biolng_coefficients = []

truck_type = ['Diesel_T', 'LNG_T', 'BioLNG_T', 'HVO100_T', 'Electric_T', 'Hydrogen_T']
cooler_type = ['Diesel_C', 'HVO100_C', 'Nitrogen_C','Electric_C']

truck_km = {
    'Diesel_T': 140000,
    'LNG_T': 130000,
    'BioLNG_T': 130000,
    'HVO100_T': 140000,
    'Electric_T': 70000,
    'Hydrogen_T': 100000
}

cooler_h = {
    'Diesel_C': 1896,
    'HVO100_C': 1896,
    'Nitrogen_C':1896,
    'Electric_C': 1896,
}

truck_costs = {
    'Diesel_T': 1.91,
    'LNG_T': 1.76,
    'BioLNG_T':1.8,
    'HVO100_T':1.95,
    'Electric_T':3.22,
    'Hydrogen_T':4.65
    }

cooler_costs = {
    'Diesel_C': 1.91,
    'HVO100_C':1.95,
    'Nitrogen_C': 1.875,
    'Electric_C':3.22
    }
    
truck_emissions_km = {
    "Diesel_T": 0.9956, 
    "LNG_T": 1.118,      
    "BioLNG_T": 0.209,  
    "HVO100_T": 0.3613,
    "Electric_T": 0.0874, 
    "Hydrogen_T": 0.0473 
}

cooler_emissions_h = {
    "Diesel_C": 12.744,
    "HVO100_C": 4.192,
    "Nitrogen_C": 6.072,
    "Electric_C": 0.2464
}

total_km=70000000
budget_azienda=131000000

#For the Single Objective Optimization the Epsilon value is 0 as it is not used in the function for this case.

epsilon_cost_so=0

#Single Objective Optimization for Costs Scenario A.2

def epsilonConstraint_nonlinear(epsilon, truckVector, coolerVector, truck_km, cooler_km,
                                 truck_costs, cooler_costs, truck_emissions, cooler_emissions,
                                 total_km, budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeReals)
    model.y = Var(coolerVector, domain=NonNegativeReals)
    model.bioLNG_HVO100_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Nitrogen_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Electric_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    
    model.coefficient_sum = Constraint(expr=
                                        model.bioLNG_HVO100_coef +
                                        model.bioLNG_Nitrogen_coef +
                                        model.bioLNG_Electric_coef == 1)
    
    model.obj = Objective(expr=
                          sum(truck_costs[i] * model.x[i] * truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j] * model.y[j] * cooler_km[j] for j in coolerVector),
                          sense=minimize)
    
    model.c1 = Constraint(expr=sum(model.x[i] * truck_km[i] for i in truckVector) >= total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector) == sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 
                          model.bioLNG_HVO100_coef * model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 
                          model.bioLNG_Nitrogen_coef * model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] >= model.x['Electric_T'] + 
                          model.x['Hydrogen_T'] + model.bioLNG_Electric_coef * model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c9 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.0352 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c10 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.14 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
# Risk management perspective: limit each truck type to < 50% of total kilometers.
    total_truck_km = sum(model.x[i] * truck_km[i] for i in truckVector)
    model.c12 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c13 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c14 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c15 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)
    
    solver = SolverFactory('ipopt')
    solver.options['max_iter'] = 10000
    solver.options['tol'] = 1e-8
    solver.options['acceptable_tol'] = 1e-5
    solver.options['mu_strategy'] = 'adaptive' 
    solver.options['print_level'] = 0
    results = solver.solve(model)
    
    truck_quantities = {truck: round(model.x[truck].value) for truck in truckVector}
    cooler_quantities = {cooler: round(model.y[cooler].value) for cooler in coolerVector}
    optimal_coefficients = {
        'BioLNG_HVO100_Coeff': model.bioLNG_HVO100_coef.value,
        'BioLNG_Nitrogen_Coeff': model.bioLNG_Nitrogen_coef.value,
        'BioLNG_Electric_Coeff': model.bioLNG_Electric_coef.value
    }
    total_km_achieved = sum(model.x[i].value * truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = total_cost_truck + \
                 total_cost_cooler
    total_emissions_truck = sum(model.x[i].value * truck_km[i] * truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value * cooler_km[j] * cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    
    return (results, truck_quantities, cooler_quantities, total_cost_truck, total_cost_cooler, total_cost, total_emissions, 
            total_km_achieved, total_emissions_truck, total_emissions_cooler, optimal_coefficients)

results_cost_so,truck_quantities_cost_so,cooler_quantities_cost_so,total_cost_truck_cost_so, total_cost_cooler_cost_so,total_cost_cost_so,total_emissions_cost_so,totalkm_cost_so,total_emissions_truck_cost_so,total_emissions_cooler_cost_so, biolng_coefficients_cost_so= epsilonConstraint_nonlinear(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)

#The final emissions value for the epsilon iteration is grabbed from the single optimization process.
single_cost_obj_emissions=total_emissions_cost_so

#Single Objective Optimization for Emissions Scenario A.2

def epsilonConstraint_nonlinear(epsilon, truckVector, coolerVector, truck_km, cooler_km,
                                 truck_costs, cooler_costs, truck_emissions, cooler_emissions,
                                 total_km, budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeReals)
    model.y = Var(coolerVector, domain=NonNegativeReals)
    model.bioLNG_HVO100_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Nitrogen_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Electric_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    
    model.coefficient_sum = Constraint(expr=
                                        model.bioLNG_HVO100_coef +
                                        model.bioLNG_Nitrogen_coef +
                                        model.bioLNG_Electric_coef == 1)
    
    model.obj = Objective(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + 
                          sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector), 
                          sense=minimize
                          )
    
    # Restricciones del modelo
    model.c1 = Constraint(expr=sum(model.x[i] * truck_km[i] for i in truckVector) >= total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector) == sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 
                          model.bioLNG_HVO100_coef * model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 
                          model.bioLNG_Nitrogen_coef * model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] >= model.x['Electric_T'] + 
                          model.x['Hydrogen_T'] + model.bioLNG_Electric_coef * model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c9 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.0352 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c10 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.14 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
# Risk management perspective: limit each truck type to < 50% of total kilometers.
    total_truck_km = sum(model.x[i] * truck_km[i] for i in truckVector)
    model.c12 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c13 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c14 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c15 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)
    
    solver = SolverFactory('ipopt')
    solver.options['max_iter'] = 10000
    solver.options['tol'] = 1e-8
    solver.options['acceptable_tol'] = 1e-5
    solver.options['mu_strategy'] = 'adaptive' 
    solver.options['print_level'] = 0
    results = solver.solve(model)
    
    truck_quantities = {truck: round(model.x[truck].value) for truck in truckVector}
    cooler_quantities = {cooler: round(model.y[cooler].value) for cooler in coolerVector}
    optimal_coefficients = {
        'BioLNG_HVO100_Coeff': model.bioLNG_HVO100_coef.value,
        'BioLNG_Nitrogen_Coeff': model.bioLNG_Nitrogen_coef.value,
        'BioLNG_Electric_Coeff': model.bioLNG_Electric_coef.value
    }
    total_km_achieved = sum(model.x[i].value * truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = total_cost_truck + \
                 total_cost_cooler
    total_emissions_truck = sum(model.x[i].value * truck_km[i] * truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value * cooler_km[j] * cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    
    return (results, truck_quantities, cooler_quantities, total_cost_truck, total_cost_cooler, total_cost, total_emissions, 
            total_km_achieved, total_emissions_truck, total_emissions_cooler, optimal_coefficients)

results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler, biolng_coefficients_mod= epsilonConstraint_nonlinear(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)
methodology.append('Environmental Single Objective')
total_truck_costs.append(total_cost_truck)
total_cooler_costs.append(total_cost_cooler)
costs.append(total_cost)
truck_emissions.append(total_emissions_truck)
cooler_emissions.append(total_emissions_cooler)
emissions.append(total_emissions)
epsilons.append(epsilon_cost_so)
truckquantities.append(truck_quantities)
coolerquantities.append(cooler_quantities)
biolng_coefficients.append(biolng_coefficients_mod)

#The initial emissions value for the epsilon iteration is grabbed from the single optimization process.

single_env_obj_emissions=total_emissions

#Scenario A.2

def epsilonConstraint_nonlinear(epsilon, truckVector, coolerVector, truck_km, cooler_km,
                                 truck_costs, cooler_costs, truck_emissions, cooler_emissions,
                                 total_km, budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeReals)
    model.y = Var(coolerVector, domain=NonNegativeReals)
    model.bioLNG_HVO100_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Nitrogen_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    model.bioLNG_Electric_coef = Var(bounds=(0, 1), domain=NonNegativeReals)
    
    model.coefficient_sum = Constraint(expr=
                                        model.bioLNG_HVO100_coef +
                                        model.bioLNG_Nitrogen_coef +
                                        model.bioLNG_Electric_coef == 1)
    
    model.obj = Objective(expr=
                          sum(truck_costs[i] * model.x[i] * truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j] * model.y[j] * cooler_km[j] for j in coolerVector),
                          sense=minimize)
    
    model.c1 = Constraint(expr=sum(model.x[i] * truck_km[i] for i in truckVector) >= total_km)
    model.c2 = Constraint(expr=(sum(model.x[i] * truck_km[i] * truck_emissions[i] for i in truckVector) + sum(model.y[j] * cooler_h[j] * cooler_emissions[j] for j in coolerVector)) <= epsilon)

    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector) == sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 
                          model.bioLNG_HVO100_coef * model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 
                          model.bioLNG_Nitrogen_coef * model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] >= model.x['Electric_T'] + 
                          model.x['Hydrogen_T'] + model.bioLNG_Electric_coef * model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c9 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.0352 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c10 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.14 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
# Risk management perspective: limit each truck type to < 50% of total kilometers.
    total_truck_km = sum(model.x[i] * truck_km[i] for i in truckVector)
    model.c12 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c13 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c14 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c15 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)
    
    solver = SolverFactory('ipopt')
    solver.options['max_iter'] = 10000
    solver.options['tol'] = 1e-8
    solver.options['acceptable_tol'] = 1e-5
    solver.options['mu_strategy'] = 'adaptive' 
    solver.options['print_level'] = 0
    
    results = solver.solve(model)
    
    truck_quantities = {truck: round(model.x[truck].value) for truck in truckVector}
    cooler_quantities = {cooler: round(model.y[cooler].value) for cooler in coolerVector}
    optimal_coefficients = {
        'BioLNG_HVO100_Coeff': model.bioLNG_HVO100_coef.value,
        'BioLNG_Nitrogen_Coeff': model.bioLNG_Nitrogen_coef.value,
        'BioLNG_Electric_Coeff': model.bioLNG_Electric_coef.value
    }
    total_km_achieved = sum(model.x[i].value * truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = total_cost_truck + \
                 total_cost_cooler
    total_emissions_truck = sum(model.x[i].value * truck_km[i] * truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value * cooler_km[j] * cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    
    return (results, truck_quantities, cooler_quantities, total_cost_truck, total_cost_cooler, total_cost, total_emissions, 
            total_km_achieved, total_emissions_truck, total_emissions_cooler, optimal_coefficients)

from matplotlib.ticker import ScalarFormatter

epsilon_values = np.geomspace(single_env_obj_emissions, single_cost_obj_emissions, 50)

for epsilon in epsilon_values:
    results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler, biolng_coefficients_mod= epsilonConstraint_nonlinear(
        epsilon, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
        truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
    )
    methodology.append('Multi Objective')
    total_truck_costs.append(total_cost_truck)
    total_cooler_costs.append(total_cost_cooler)
    costs.append(total_cost)
    truck_emissions.append(total_emissions_truck)
    cooler_emissions.append(total_emissions_cooler)
    emissions.append(total_emissions)
    epsilons.append(epsilon)
    truckquantities.append(truck_quantities)
    coolerquantities.append(cooler_quantities)
    biolng_coefficients.append(biolng_coefficients_mod)


#After making the multi objective optimization the single economic objective optimization results are added to be graphed.

methodology.append('Economic Single Objective')
total_truck_costs.append(total_cost_truck_cost_so)
total_cooler_costs.append(total_cost_cooler_cost_so)
costs.append(total_cost_cost_so)
truck_emissions.append(total_emissions_truck_cost_so)
cooler_emissions.append(total_emissions_cooler_cost_so)
emissions.append(total_emissions_cost_so)
epsilons.append(epsilon_cost_so)
truckquantities.append(truck_quantities_cost_so)
coolerquantities.append(cooler_quantities_cost_so)
biolng_coefficients.append(biolng_coefficients_cost_so)


rounded_coefficients = [
    {key: round(value, 2) for key, value in coeff.items()}
    for coeff in biolng_coefficients
]

biolng_coefficients = rounded_coefficients

plt.figure(figsize=(12, 8))
colors = cm.RdYlGn_r(np.linspace(0, 1, len(epsilon_values)))
for i in range(len(epsilon_values)):
    plt.plot(emissions[i], costs[i], 'o', color=colors[i])

plt.plot(emissions, costs, linestyle='-', color='navy')

plt.xlabel('Total Emissions (Kg CO2e)', fontsize=20)
plt.ylabel('Total Cost (€)', fontsize=20)
plt.title('Pareto Frontier between Cost and Emissions', fontsize=20, fontweight='bold')

plt.gca().yaxis.set_major_formatter(ScalarFormatter())
plt.gca().xaxis.set_major_formatter(ScalarFormatter())
plt.gca().ticklabel_format(style="plain", axis="both")

plt.grid(True, linestyle='--', alpha=0.6)

plt.tight_layout()
plt.show()

#Plot truck types chosen

iterations = range(len(truckquantities))
truck_types = truck_type

truck_data = np.array([[iteration.get(truck, 0) for truck in truck_types] for iteration in truckquantities])


total_costs = costs

colors = cm.get_cmap("tab10", len(truck_types))

plt.figure(figsize=(12, 6))

for i, truck in enumerate(truck_types):
    plt.plot(iterations, truck_data[:, i], label=f"{truck}", color=colors(i))

budget_limit = 131000000
under_budget = True
start = 0

for i, total_cost in enumerate(total_costs):
    if total_cost > budget_limit and under_budget:
        # Mark under-budget region
        plt.axvspan(start, i, color="green", alpha=0.1, label="Under Budget" if start == 0 else "")
        under_budget = False
        start = i
    elif total_cost <= budget_limit and not under_budget:
        # Mark over-budget region
        plt.axvspan(start, i, color="red", alpha=0.1, label="Over Budget" if start == 0 else "")
        under_budget = True
        start = i

if under_budget:
    plt.axvspan(start, len(total_costs), color="green", alpha=0.1, label="Under Budget")
else:
    plt.axvspan(start, len(total_costs), color="red", alpha=0.1, label="Over Budget")

plt.title("Truck Quantities Across Iterations with Budget Constraint")
plt.xlabel("Iterations")
plt.ylabel("Number of Trucks")
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))
plt.tight_layout()
plt.show()

# Plot cooler types chosen

iterations = range(len(coolerquantities))
cooler_types = cooler_type

cooler_data = np.array([[iteration.get(cooler, 0) for cooler in cooler_types] for iteration in coolerquantities])

total_costs = costs

colors = cm.get_cmap("tab10", len(cooler_types))

plt.figure(figsize=(12, 6))

for i, cooler in enumerate(cooler_types):
    plt.plot(iterations, cooler_data[:, i], label=f"{cooler}", color=colors(i))

budget_limit = 131000000
under_budget = True
start = 0

for i, total_cost in enumerate(total_costs):
    if total_cost > budget_limit and under_budget:
        # Mark under-budget region
        plt.axvspan(start, i, color="green", alpha=0.1, label="Under Budget" if start == 0 else "")
        under_budget = False
        start = i
    elif total_cost <= budget_limit and not under_budget:
        # Mark over-budget region
        plt.axvspan(start, i, color="red", alpha=0.1, label="Over Budget" if start == 0 else "")
        under_budget = True
        start = i

if under_budget:
    plt.axvspan(start, len(total_costs), color="green", alpha=0.1, label="Under Budget")
else:
    plt.axvspan(start, len(total_costs), color="red", alpha=0.1, label="Over Budget")

plt.title("Cooler Quantities Across Iterations with Budget Constraint")
plt.xlabel("Iterations")
plt.ylabel("Number of Coolers")
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))
plt.tight_layout()
plt.show()

plt.figure(figsize=(10, 6))
iterations = range(1, len(costs) + 1)

plt.plot(iterations, costs, label="Total Cost",  linestyle='-', color='blue')
plt.plot(iterations, total_truck_costs, label="Total Truck Cost", linestyle='--', color='green')
plt.plot(iterations, total_cooler_costs, label="Total Cooler Cost", linestyle='-.', color='red')

plt.xlabel("Iteration", fontsize=12)
plt.ylabel("Cost (€)", fontsize=12)
plt.title("Cost Comparison Across Iterations", fontsize=14)
plt.legend(fontsize=10)
plt.grid(True, linestyle='--', alpha=0.7)

plt.tight_layout()
plt.show()

# Plotting the emissions per iteration
plt.figure(figsize=(10, 6))
iterations = range(1, len(emissions) + 1)

plt.plot(iterations, emissions, label="Total Emissions", linestyle='-', color='purple')
plt.plot(iterations, truck_emissions, label="Truck Emissions", linestyle='--', color='orange')
plt.plot(iterations, cooler_emissions, label="Cooler Emissions", linestyle='-.', color='magenta')

plt.xlabel("Iteration", fontsize=12)
plt.ylabel("Emissions (Kg CO2e)", fontsize=12)
plt.title("Emissions Comparison Across Iterations", fontsize=14)
plt.legend(fontsize=10)
plt.grid(True, linestyle='--', alpha=0.7)

plt.tight_layout()
plt.show()


#Coefficient graphing

# Extract each coefficient into separate list for plotting
bioLNG_HVO100_coeffs = [coeff['BioLNG_HVO100_Coeff']*100 for coeff in biolng_coefficients]
bioLNG_Nitrogen_coeffs = [coeff['BioLNG_Nitrogen_Coeff']*100 for coeff in biolng_coefficients]
bioLNG_Electric_coeffs = [coeff['BioLNG_Electric_Coeff']*100 for coeff in biolng_coefficients]

plt.figure(figsize=(10, 6))
iterations = range(1, len(biolng_coefficients) + 1)

plt.plot(iterations, bioLNG_HVO100_coeffs, label='BioLNG-HVO100')
plt.plot(iterations, bioLNG_Nitrogen_coeffs, label='BioLNG-Nitrogen')
plt.plot(iterations, bioLNG_Electric_coeffs, label='BioLNG-Electric')

plt.title('BioLNG Coefficients Over Iterations')
plt.xlabel('Iteration')
plt.ylabel('Coefficient Value (%)')
plt.legend()

plt.show()


dic_to_excel = [
    {'Methodology': methodology, **d1, **d2, 'Truck Cost': truck_c, 'Cooler Cost': cooler_c,
     'Cost': cost, 'Max_Budget': budget_azienda, 
     'Truck Emissions': truck_em, 'Cooler Emissions': cooler_em, 
     'Emissions': emission, 'Emission Cap': epsilon, 
     'BioLNG_HVO100_Coeff': coef['BioLNG_HVO100_Coeff'],
     'BioLNG_Nitrogen_Coeff': coef['BioLNG_Nitrogen_Coeff'],
     'BioLNG_Electric_Coeff': coef['BioLNG_Electric_Coeff']}
    for methodology, d1, d2, truck_c, cooler_c, cost, emission, epsilon, truck_em, cooler_em, coef 
    in zip(methodology, truckquantities, coolerquantities, total_truck_costs, total_cooler_costs, costs, emissions, epsilons, truck_emissions, cooler_emissions, biolng_coefficients)
]

al_excel = pd.DataFrame(dic_to_excel)

file_path = 'C:/Users/agusv/Desktop/Estudio/Tesis/Csv/Excel_Files/E_Constraint_Simulation_Scenarios.xlsx'

try:
    with pd.ExcelWriter(file_path, engine='openpyxl', mode='a', if_sheet_exists='replace') as writer:
        al_excel.to_excel(writer, sheet_name='Scenario A.2', index=True)
except FileNotFoundError:
    with pd.ExcelWriter(file_path, engine='openpyxl') as writer:
        al_excel.to_excel(writer, sheet_name='Scenario A.2', index=True)

